// parseUri 1.2.2
// (c) Steven Levithan <stevenlevithan.com>
// MIT License

function parseUri (str) {
	var	o   = parseUri.options,
		m   = o.parser[o.strictMode ? "strict" : "loose"].exec(str),
		uri = {},
		i   = 14;

	while (i--) uri[o.key[i]] = m[i] || "";

	uri[o.q.name] = {};
	uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2) {
		if ($1) uri[o.q.name][$1] = $2;
	});

	return uri;
};

parseUri.options = {
	strictMode: false,
	key: ["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],
	q:   {
		name:   "queryKey",
		parser: /(?:^|&)([^&=]*)=?([^&]*)/g
	},
	parser: {
		strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
		loose:  /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
	}
};

// 页面的内核类型
var CORE_TYPE = {
	IE: 0,
	WEBKIT: 1
};

// 内核切换通知
var
	STATIS_CORESWITCHEX_TIPS_SWITCH         = 1110102, // 强名单下点击切换按钮后tips中点击继续切换的次数
	STATIS_CORESWITCHEX_IE_TIPS_SHOW_SWITCH = 1110104, // Ie内核下标记tips出现后点击继续切换的次数
	STATIS_CORESWITCHEX_WK_TIPS_SHOW_SWITCH = 1110106, // webkit内核下标记tips出现后点击继续切换的次数
	STATIS_CORESWITCHEX_SWITCH_TIPS_IKNOW   = 1110107, // 强名单下点击切换按钮后tips中点击我知道了的次数
	STATIS_CORESWITCHEX_SWITCH_TIPS_X       = 1110108, // 强名单下点击切换按钮后tips中点击叉的次数
	STATIS_CORESWITCHEX_IE_TIPS_IKNOW       = 1110109, // Ie内核下标记tips出现后点击我知道了的次数
	STATIS_CORESWITCHEX_IE_TIPS_X           = 1110110, // Ie内核下标记tips出现后点击叉的次数
	STATIS_CORESWITCHEX_WK_TIPS_IKNOW       = 1110111, // webkit内核下标记tips出现后点击我知道了的次数
	STATIS_CORESWITCHEX_WK_TIPS_X           = 1110112; // webkit内核下标记tips出现后点击叉的次数
	

/**
 * Created by .
 * User: crisweng
 * Date: 11-9-13
 * Time: 下午1:15
 * To change this template use File | Settings | File Templates.
 */

var tip = {
    arrow: null,   //@type {HTMLElement}
    tipBox: null,
    title: null,
    icon: null,
    text: null,
    closeButton:null,
    action:null,   //@type {HTMLElement}
    init: function(){
        var _this = this, textObject;
        document.onselectstart = document.ondragstart = function() {
        return false;
        };
        //@type {object} textObject 从皮肤传过来的tipArgs.param
        // {object} param 前端需要传递给气泡页面的参数
        // {String} id    气泡id 标识不同的气泡进行不同的处理
        //｛object｝ strianglePosition 三角尖水平或垂直的显示位置
        // {String} strianglePosition.direction ="center" 气泡显示位置enum {"left","right","center","custom"};
        // {Number} strianglePosition.x||y 三角尖向左或向上的偏移量
        //｛String｝ direction  三角尖显示位置 enum{"left","right","bottom","top"}
        // {String} isTitle = "true" 是否显示名称
        // ｛String｝ isAction ="true" 是否有操作区域
        // ｛String｝ isIcon = "true" 是否显示图标
        // ｛String｝ isCloseButton = "true" 是否显示关闭按钮
        // {String} title title内容
        // {String} text text内容
       textObject = qqbrowser.extension.page.initData;
        _this.arrow = document.getElementById("arrow");
        _this.tipBox = document.getElementById("tip-box");
        _this.title = document.getElementById("title");
        _this.icon = document.getElementById("tip-icon");
        _this.text = document.getElementById("text");
        _this.closeButton = document.getElementById("tip-close");
        _this.action = document.getElementById("action");
        if(textObject.hasOwnProperty('id')){
            _this.tipBox.addClass(unescape(textObject['id']));
        }
        if(textObject.hasOwnProperty('title')){
            _this.setText(_this.title,unescape(textObject['title']));
        }
        if(textObject.hasOwnProperty('text')){
            _this.setText(_this.text,unescape(textObject['text']));
        }
        if(textObject.hasOwnProperty('isCloseButton')&&
            unescape(textObject['isCloseButton']) === "false"){
            _this.hideDiv(_this.closeButton);
        }
        if(textObject.hasOwnProperty('isIcon')&&
            unescape(textObject['isIcon']) === "false"){
            _this.hideDiv(_this.icon);
        }
        if(textObject.hasOwnProperty('isTitle')&&
            unescape(textObject['isTitle']) === "false"){
            _this.hideDiv(_this.title);
        }

        if(textObject.hasOwnProperty('isAction')&&
            unescape(textObject['isAction']) === "false"){
            _this.hideDiv(_this.action);
        }
		_this.titleSet(unescape(textObject['id']),unescape(textObject['status']));
        _this.textSet(unescape(textObject['id']),unescape(textObject['status']));
        _this.setAction(unescape(textObject['id']),unescape(textObject['status']));
        _this.addEvtListener(unescape(textObject['id']));
        _this.buidTip(unescape(textObject['id']), textObject);
    },
    titleSet: function(id, status){
        var text = "";
        if(id){
            var _this = this;
            if(id == "newSkinTip"){
                 /*text = "怀念彩色图标+文字和传统的标签栏吗？<strong>经典皮肤<\/strong>来了！";
                 _this.setText(_this.title,text);*/

            }else if(id == "popupBlockTip"){
                 _this.setText(_this.title,"有弹出窗口被拦截");
            } else if (id === 'mismatchedCoreTypeBalloontip') {
				text = status == CORE_TYPE.IE ? '已为您智能切换至兼容模式' : '已为您智能切换至极速模式';
				_this.setText(_this.title,text);
			} else if (id === 'compulsoryCoreTypeBalloontip') {
				_this.setText(_this.title,'此网站只适合兼容模式');
			}
        }
    },
    textSet:function(id,status){
        var text = "";
        if (id) {
            switch (id) {
                case "popupBlockTip":{
                    text = "有1个弹出窗口被拦截，要打开被拦截的窗口请单击此按钮...";
                }
                    break;
                case "sidebarTip":{
                    text = "网购更方便，还能省钱哦";
                }
                case "soundControlTip": {
                    if (status && status == "close") {
                        text = "QQ浏览器已进入静音状态！";

                    } else if (status && status == "open") {
                        text = "QQ浏览器的声音已开启！";
                    }
                    this.icon.addClass(status);
                }
                    break;
                case "coreChangeTip": {
                    if(status && status == "A"){
                        text ="您目前浏览的是网银支付页面，切换内核会导致您的支付行为无法正常完成";
                    } else if (status && status == "B"){
                        text = "此网页只支持兼容模式</br>切换内核会导致网页无法正常显示";
                    }
                    break;
                }
				case 'compulsoryCoreTypeBalloontip':
					text = '切换后可能导致无法正常显示，建议保留当前模式';
					// text = '此网站的设计只适合兼容模式，切换后可能导致无法正常使用，建议保留当前模式';
					break;
				case 'mismatchedCoreTypeBalloontip':
					// 0 是用IE内核打开，1是Webkit
					text = '您上次选择的模式可能导致此网站无法正常显示';
					// text = status == 0 ? '已为您智能切换至兼容模式<br>您上次选择的模式可能导致此网站无法正常显示' : '已为您智能切换至极速模式<br>您上次选择的模式可能导致此网站无法正常显示';
					break;
                case "cloudDictTip": {
                    text = "QQ云词典已开启，在当前网页选中单词就可以翻译哦~常来用用！";
;
                }
            }
            this.setText(this.text, text);
        }
    },
    setAction: function(id, status){
        if(id && id === "QzoneHelpTip"){
            var button = document.createElement("div");
            button.addClass("Button");
            button.setAttribute("id",status);
            if(status && (status === "restore" || status === "process")){
                button.innerHTML = "一键修复";
                this.action.appendChild(button);
				if(status === "process"){
				    this.text.addClass("process");
                    var img = [this.text.innerHTML,"<img style='margin-left:4px' src = \"images/clean.gif\"/>"].join("");
                    this.text.innerHTML = img;
				    button.addClass("disabled");
				}else{
				    button.addEventListener("click",function(){
				        var obj = {};
				        obj.command="clearCache";
		                try{
			               var cleanGUID = "{510EEC09-09E9-4003-AFDD-CCB3803286C3}";
			               qqbrowser.extension.sendRequest( cleanGUID, obj , function(reply) {});
		                }catch(err){}
                    },false);
		        }
                
            }else if(status && status === "fail"){
			    this.icon.addClass(status);
				this.text.addClass(status);
                button.innerHTML = "报告给我们";
                this.action.appendChild(button);
                button.addEventListener("click",function(){
                    //TODO
                },false);
            }else if(status && status === "process"){
			    this.icon.addClass(status);

                button.innerHTML = "确定";
                this.action.appendChild(button);

                button.addEventListener("click",function(){
                    qqbrowser.tip.destoryMe();
                },false);
            }
	    }else if(id && id == "newSkinTip"){
            button = document.createElement("div");
            button.addClass("Button");
            button.setAttribute("id","useSkin");
            /*button.innerHTML = "立即使用";*/
            this.action.appendChild(button);
            button.addEventListener("click",function(){
				qqbrowser.skin.setTheme("newyear2012");
				qqbrowser.extension.builtin.config.set({skin:"newyear2012"},function(){
					qqbrowser.tip.destroyMe();
				});
            },false);
        } else if (id && id == "coreChangeTip") {
            button = document.createElement("div");
            button.addClass("Button");
            button.setAttribute("id","coreChange");
            button.innerHTML = "我知道了";
            this.action.appendChild(button);
            button.addEventListener("click", function() {
                qqbrowser.tip.destroyMe();
            });
		} else if (id == 'compulsoryCoreTypeBalloontip' || id == 'mismatchedCoreTypeBalloontip') {
			var coreType = parseInt(parseUri(location.href).queryKey.coreType);
			
			this.tipBox.addClass('core-type');
			this.action.innerHTML = '<div id="core-switch"><a id="core-switch-link" href="javascript:void(0)">继续切换</a></div><div id="i-see" class="Button">我知道了</div>';
			// 点击“我知道了”命令按钮
			document.getElementById('i-see').addEventListener('click', function() {
				// 点击“我知道了”，“则删去用户主动切换历史记录里的此网站数据；” @see: http://tapd.oa.com/v3/qqbrowser5_1/prong/stories/view/1010028451005052940
				// 那么这个domain下的页面就不会再弹用户主动切换历史和推荐名单冲突的通知（Notification）了。
				qqbrowser.tabs.coreSwitch(parseInt(parseUri(location.href).queryKey.pageId), 1);
				// 数据统计：点击“我知道了”的次数
				qqbrowser.extension.builtin.statistics.increase(id == 'compulsoryCoreTypeBalloontip' ? STATIS_CORESWITCHEX_SWITCH_TIPS_IKNOW : (coreType === CORE_TYPE.IE ? STATIS_CORESWITCHEX_IE_TIPS_IKNOW : STATIS_CORESWITCHEX_WK_TIPS_IKNOW));
				
				// 强名单的“我知道了”关闭通知
				if(id == 'compulsoryCoreTypeBalloontip') {
					qqbrowser.tip.destroyMe();
				// 推荐名单的“我知道了”在config记一个标志为，以后不再提示
				} else {
					qqbrowser.extension.builtin.config.set({showCoreSwitchTip: false}, function() {
						qqbrowser.tip.destroyMe();
					});
				}
			});
			// 点击“继续切换”链接
			document.getElementById('core-switch-link').addEventListener('click', function() {
				// 切换内核
				qqbrowser.tabs.coreSwitch(parseInt(parseUri(location.href).queryKey.pageId));
				// 数据统计：点击“继续切换”的次数
				qqbrowser.extension.builtin.statistics.increase(id == 'compulsoryCoreTypeBalloontip' ? STATIS_CORESWITCHEX_TIPS_SWITCH : (coreType === CORE_TYPE.IE ? STATIS_CORESWITCHEX_IE_TIPS_SHOW_SWITCH : STATIS_CORESWITCHEX_WK_TIPS_SHOW_SWITCH));
				qqbrowser.tip.destroyMe();
			});
		}
	},
    addEvtListener: function (id){
        switch(id){
            case "cloudDictTip":{
                this.icon.addEventListener("click",function(){
                    qqbrowser.tabs.create("http://dict.qq.com/",2, 0);
                },false);
                break;
            }
        }
    },
    setText: function(element, text){
        if(!text||!element){
            return;
        }
        element.innerHTML = text;
    },
    hideDiv :function(element){
        element.style.display = "none";
    },
    buidTip: function(id, textObject) {
        var _this = this;
        var tipPos = _this.getPosition(_this.tipBox);
		var clientRect = _this.tipBox.getBoundingClientRect();
			width = clientRect.right + parseInt(document.defaultView.getComputedStyle(_this.tipBox).marginRight),
			height = clientRect.bottom + parseInt(document.defaultView.getComputedStyle(_this.tipBox).marginBottom);

        qqbrowser.extension.page.show({width: width, height: height});
		

        if (_this.closeButton) {

            try {
                _this.closeButton.addEventListener("click", function() {
					if (id == 'compulsoryCoreTypeBalloontip' || id == 'mismatchedCoreTypeBalloontip') {
						var coreType = parseInt(parseUri(location.href).queryKey.coreType);
						// 数据统计：点击“X”关闭按钮的次数
						qqbrowser.extension.builtin.statistics.increase(id == 'compulsoryCoreTypeBalloontip' ? STATIS_CORESWITCHEX_SWITCH_TIPS_X : (coreType === CORE_TYPE.IE ? STATIS_CORESWITCHEX_IE_TIPS_X : STATIS_CORESWITCHEX_WK_TIPS_X));
					}
                    qqbrowser.tip.destroyMe();
                }, false);
            } catch(e) {
                console.log(e);
            }
        }

    },
    getPosition: function(element){
        var left = 0;
	    var top = 0;
        if(typeof(element) === undefined){
            return;
        }
	    if (element.getBoundingClientRect) {
	        var pos = element.getBoundingClientRect();
		    left = pos.left + document.documentElement.scrollLeft;
		    top = pos.top + document.documentElement.scrollTop;
		    return {
		        Left : left,
			    Top : top
		    };
        } else {
		    while (element.offsetParent) {
			    left += element.offsetLeft;
			    top += element.offsetTop;
			    element = element.offsetParent;
		    }
		    return {
			    Left : left,
			    Top : top
		    };
        }
    }

};
window.onload = function(){
    tip.init();
};